function [D, cov_mat, err_D, err_cov, err_rec, counter] = algorithm1(Max_iterations, MaxFunctionEvaluation, sparsity, N_try, inner_loop_iter, lambda, Data, true_D, true_cov_mat,sigma)
options = optimoptions('fmincon', 'Algorithm', 'sqp', 'MaxIterations', Max_iterations, 'MaxFunctionEvaluations', MaxFunctionEvaluation, 'Display', 'off');


D = 0;

[N_feature, N_sample] = size(Data);

N_total = N_feature * N_sample;

cov_mat = (1/N_sample) * (Data * Data');

err_D = zeros(1,N_try);
err_cov = zeros(1,N_try);
err_rec = zeros(1,N_try);

counter = 0;
for j = 1:N_try
    D_optimized = randn(N_feature, N_feature);
    
    if(j==1)
        counter = counter + 1;
        err_D(counter) = (1/N_feature^2) * norm(D_optimized - true_D, 'fro')^2;
        err_cov(counter) = (1/N_feature^2) * norm(true_cov_mat - D_optimized * diag(diag(cov_mat)) * D_optimized', 'fro')^2;
        err_rec(counter) = (1/N_total) * norm(Data - D_optimized * Data);
    end
   
    for i = 1:inner_loop_iter
        [D_optimized, fval] = fmincon(@(D)cost(D,lambda, sigma), D_optimized, [], [], [], [], [], [], @(D)constraint(D, Data, cov_mat), options);
        D_optimized = sparser1(D_optimized, sparsity);
    end
    if(j == 1)
        fval_0 = fval;
    end
    if(fval<fval_0)
        counter = counter + 1;
        D = D_optimized;
        fval_0 = fval;
        err_D(counter) = (1/N_feature^2) * norm(D_optimized - true_D, 'fro')^2;
        err_cov(counter) = (1/N_feature^2) * norm(true_cov_mat - D_optimized * diag(diag(cov_mat)) * D_optimized', 'fro')^2;
        err_rec(counter) = (1/N_total) * norm(Data - D_optimized * Data);
    end

end
err_D = err_D(1:counter);
err_cov = err_cov(1:counter);
err_rec = err_rec(1:counter);
cov_mat = D * diag(diag(cov_mat)) * D';
end